package mole.entities.items 
{
	import mole.entities.CPlayer;
	import mole.entities.ICollectable;
	import mole.Main;
	import net.flashpunk.Entity;
	import net.flashpunk.graphics.Image;
	
	/**
	 * Représentation d'un item.
	 * @author Cédric Liaudet
	 */
	public class IItem extends Entity implements ICollectable
	{
		/**
		 * Constructeur.
		 */
		function IItem(_PosX:Number, _PosY:Number, _iType:Number)
		{
			this.x = _PosX;
			this.y = _PosY;
			// Chargement du personnage.
			//Main.World.add(this);
			
			type = "item";
		}
		
		/**
		 * Callback quand un personnage rammasse l'item.
		 * @param	_Player Le personnage qui collecte l'objet.
		 */
		public function OnCollected(_Player:CPlayer):void
		{
			OnDestroy();			
		}
		
		/**
		 * Callback quand l'item est détruit/consommé.
		 */
		public function OnDestroy():void
		{
			Main.World.remove(this);
		}
	}
	
}